#!/bin/sh
######################################################################
######################################################################
#Configuration der Parameters
user="$(users)"
VER_WEBMIN=webmin_1.550_all.deb
URL_WEBMIN=http://prdownloads.sourceforge.net/webadmin/$VER_WEBMIN
LIB_OSCAMBUILD="build-essential fakeroot libpcsclite-dev libssl-dev cmake libusb-1.0-0-dev subversion"
LIB_LSUSB="usbutils"
LIB_JOE="joe dialog"
LIB_WEBMIN="libio-pty-perl libnet-ssleay-perl openssl apt-show-versions libauthen-pam-perl"
LIB_CRON="cron"
LIB_SAMBA="libcupsys2 samba samba-common samba-common-bin"
LIB_PROFTP="proftpd"
LIB_SPRACH="locales language-env"

######################################################################
######################################################################
#INFO


clear
echo ""
echo ""
echo ""
echo ""
echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "         !!                                                         !!"
echo "         !!                                                         !!"
echo "         !!   Dies ist eine Installationshilfe für diverse Pakete   !!"
echo "         !!               auf dem Seagate-Dockstar                  !!"
echo "         !!                                                         !!"
echo "         !!               http://streamboard.tv                 !!"
echo "         !!                                                         !!"
echo "         !!                                                         !!"
echo "         !!                                        Author:LarsRosen !!"
echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
sleep 10
clear
##########################################################
##########################################################	
#Abfrage der Installation Pakete
echo -n "Wollen sie Oscam selbst erstellen? Y/N:"

	read oscam_build

echo ""
clear
echo -n "Wollen sie lsusb verwenden? Y/N/i:"
	read lsusb
	if [ "$lsusb" = "I" -o "$lsusb" = "i" ]; then
	
		echo "!!!INFO!!!"
		echo ""
		echo "lsusb ist ein Befehl um angesteckte USB-Geräte sich anzeigen zu lassen"
		echo ""
		echo -n "Wollen sie lsusb jetzt verwenden? Y/N:"
		read lsusb
	fi

echo ""
clear
echo -n "Wollen sie Editor Joe verwenden? Y/N/i:"
	read joe
	if [ "$joe" = "I" -o "$joe" = "i" ]; then
	
		echo "!!!INFO!!!"
		echo ""
		echo "Joe ist ein Text-Editor der leicht zu bedienen ist"
		echo "Bedienung:"
		echo "Speichern und Ende = [STRG]+k+x"
		echo "Ende ohne Speichern = [STRG]+x"
		echo ""
		echo -n "Wollen sie Joe jetzt verwenden? Y/N:"
		read joe
	fi
echo ""
clear
echo -n "Wollen sie Webmin verwenden? Y/N/i:"
	read webmin
	if [ "$webmin" = "I" -o "$webmin" = "i" ]; then
	
		echo "!!!INFO!!!"
		echo ""
		echo "Webmin ist ein Web basiertes Administration tool"
		echo "Mit Webmin kann man sein Dockstar bequem über ein WebIF steuren und einstellen"
		echo "Webseite von Webmin: IPvonDockstar:10000"
		echo "Beispiel: 192.168.178.222:10000"
		echo "Login und Passwort wie in der Shell"		
		echo ""
		echo -n "Wollen sie Webmin jetzt verwenden? Y/N:"
		read webmin
	fi
echo ""
clear
echo -n "Wollen sie eine Zeitsteurung (Cron) werwenden? Y/N/i:"
	read cron
	if [ "$cron" = "I" -o "$cron" = "i" ]; then
		
		echo "!!!INFO!!!"
		echo ""
		echo "Cron ist ein Befehl um Scripte oder Befehle zu einer Bestimmten Zeit auszuführen "
		echo "Er wird für Watchdog's benötigt"
		echo ""
		echo -n "Wollen sie cron jetzt verwenden? Y/N:"
		read cron
	fi
echo ""
clear
echo -n "Wollen sie Samba verwenden? Y/N/i:"
	read samba
	if [ "$samba" = "I" -o "$samba" = "i" ]; then
	
		echo "!!!INFO!!!"
		echo ""
		echo "Samba ermögtlich es ein Windows Share-Server einzurichten"
		echo "Man kann Festplatten,Drucker... Freigeben so das sie von Windows-, Unix -system"
		echo "als Netzerkgeräte benutzt werden können."
		echo "Die Konfiguration ist über Webmin leicht einzustellen" 
		echo ""
		echo -n "Wollen sie Samba jetzt verwenden? Y/N:"
		read samba
	fi
echo ""
clear
echo -n "Wollen sie einen FTP-Server verwenden? Y/N/i:"
	read proftp
	if [ "$proftp" = "I" -o "$proftp" = "i" ]; then

		echo "!!!INFO!!!"
		echo ""		
		echo "ProFTP ermögtlich es ein FTP-Server einzurichten"
		echo "Man kann bequem über einen FTP-Programm sein DS verwalten"
		echo ""
		echo "bei der Installation Bitte Standalone auswählen"
		echo ""
		echo -n "Wollen sie einen jetzt FTP-Server verwenden? Y/N:"
		read proftp
	fi
echo ""
clear
echo -n "Wollen sie die Uhr Automatisch aktualisieren? Y/N/i:"
	read uhr
	if [ "$uhr" = "I" -o "$uhr" = "i" ]; then

		echo "!!!INFO!!!"
		echo ""
		echo "Da der Dockstar keine Hardware uhr hat ist es"
		echo "notwendig bei jedem Reboot die Uhrzeit neu"
		echo "einzustellen, dies übernimmt dann dieses Script"
		echo ""
		echo -n "Wollen sie die Uhr Automatisch aktualisieren? Y/N:"
		read uhr
	fi
echo ""
clear
echo -n "Wollen sie die Sprache für $user auf Deutsch stellen? Y/N/i:"
	read lang
	if [ "$lang" = "I" -o "$lang" = "i" ]; then

		echo "!!!INFO!!!"
		echo ""
		echo "Da der Debian standart auf English ist"
		echo "können sie hiermit für den aktuell angemeldeten User"
		echo "die Sprach auf Deutsch stellen"
		echo ""
		echo -n "Wollen sie die Sprache für $user auf Deutsch stellen? Y/N:"
		read lang
	fi
echo ""
clear
echo -n "Wollen sie Oscam Installieren? Y/N/i:"
	read oscamd
	if [ "$oscamd" = "I" -o "$oscamd" = "i" ]; then

		echo "!!!INFO!!!"
		echo ""
		echo "Oscam ist ein Multi-Protokoll-Card-Server"
		echo "Es werden die Standart Oscam Config's geladen"
		echo "WebIf ist erreichbar unter: IP:8888"
		echo "Login: myusername"
		echo "Password: mypassword"
		echo ""
		echo "Mit diesem Installer wird ein Auto-Start-Script"
		echo "hinzugefügt."
		echo ""
		echo "Das Script beinhaltet die Funktionen:"
		echo "Start,Stop,Update"
		echo ""
		echo "Start:Oscam startet"
		echo "Stop: Oscam stopt"
		echo "Update: Lädt aktuelle svn runter, kompiliert diesen mit WEBIF"
		echo ""
		echo "Das script ist aufrufbar mit:"
		echo "service oscamstart XXXX     (XXXX=Start|Stop|Update)"
		echo ""
		echo -n "Wollen sie Oscam Installieren? Y/N:"
		read oscamd
	fi
echo""

	if [ "$oscamd" = "Y" -o "$oscamd" = "y" ];then
		
		echo -n "Möchten sie einen Watchdog ob Oscam läuft einrichten? Y/N/i:"
			read watch
		if [ "$watch" = "i" -o "$watch" = "I" ]; then
			echo "INFO!!!"
			echo ""
			echo "Der Oscam-Watchdog überwacht,das Oscam"
			echo "dauerhaft und starten es ggf. neu"					
			echo -n "Wollen sie den Watchdog jetzt einrichten? Y/N:"
			read watch
				
		fi
			
		if [ "$watch" = "Y" -o "$watch" = "y" ]; then
			OSCAM_START='"$CONFIGDIR"oscams.sh &'
			OSCAMS_STOP='pkill oscams.sh'
				
		else
			OSCAM_START='$DAEMON -c $CONFIGDIR $OPTIONS'
		fi	
	fi		
echo ""

###############################################################
###############################################################
#Ausführen der Installationen


	if [ "$oscam_build" = "Y" -o "$oscam_build" = "y" ]; then

		echo "Oscam-build wird Installiert!"
		apt-get -y --force-yes install $LIB_OSCAMBUILD
		echo "Oscam-build wird konfiguriert"
		ln -s /usr/lib/libcrypto.so.0.9.8 /usr/lib/libcrypto.so.6
		ln -s /usr/lib/libssl.so.0.9.8 /usr/lib/libssl.so.6
		sleep 10
	fi

	if [ "$lsusb" = "Y" -o "$lsusb" = "y" ]; then

		echo "lsusb wird Installiert!"
		apt-get -y --force-yes install $LIB_LSUSB
		sleep 10
	fi

	if [ "$joe" = "Y" -o "$joe" = "y" ]; then

		echo "Editor-Joe wird Installiert!"
		apt-get -y --force-yes install $LIB_JOE
		sleep 10
	fi

	if [ "$webmin" = "Y" -o "$webmin" = "y" ]; then

		echo "Webmin-libs wird Installiert!"
		apt-get -y --force-yes install $LIB_WEBMIN
		sleep 10	
		echo "Webmin wird Heruntergeladen"
		wget -P /tmp $URL_WEBMIN
		sleep 2
		echo "Webmin wird Installiert"
		dpkg -i /tmp/$VER_WEBMIN
		sleep 1
	fi

	if [ "$cron" = "Y" -o "$cron" = "y" ]; then

		echo "Cron wird Installiert!"
		apt-get -y --force-yes install $LIB_CRON
		sleep 10
	fi

	if [ "$samba" = "Y" -o "$samba" = "y" ]; then

		echo "Samba wird Installiert!"
		apt-get -y --force-yes install $LIB_SAMBA
		sleep 10
	fi

	if [ "$proftp" = "Y" -o "$proftp" = "y" ]; then

		echo "FTP-Server wird Installiert!"
		clear
		echo ""
		echo ""
		echo ""
		echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
		echo "         !!                                             !!"
		echo "         !!                                             !!"
		echo "         !!               ACHTUNG                       !!"
		echo "         !!                                             !!"
		echo "         !!       BITTE standalone Auswählen            !!"
		echo "         !!                                             !!"
		echo "         !!                                             !!"
		echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
		sleep 10		
		apt-get -y --force-yes install $LIB_PROFTP
		sleep 1
		clear		
		echo "Prüfe Hosts auf Einträge"		
		sleep 2		
		if [ "$(grep -c "debian" /etc/hosts)" = 0 ];then 
			echo "Eintrag wird gesetzt"		
			sleep 2		
			sed -e '1a\127.0.0.1	debian' -i /etc/hosts
		else 	
			echo "Eintrag vorhanden"
		fi
			
			sed -e 's/^root.*/#root/' -i /etc/ftpusers
			echo "Prüfe eintrag für Root Login"
			if [ "$(grep -c "RootLogin                       on" /etc/proftpd/proftpd.conf)" = 0 ]; then
				sed -e '/^DeferWelcome/aRootLogin                       on' -i /etc/proftpd/proftpd.conf			
			else
				echo "Eintrag Vorhanden"
			fi	
			echo "Starte ProFTP"			
			/etc/init.d/proftpd reload
			/etc/init.d/proftpd start
		fi

			if [ "$uhr" = "Y" -o "$uhr" = "y" ]; then
	
			echo "Uhr-Script wird Installiert!"
			echo "#!/bin/sh"	> /root/GetDate.sh
			echo "SERVER="atom.uhr.de"" >> /root/GetDate.sh
			echo "( /bin/sleep 2s && /bin/ping -c 2 ${SERVER} 2>&1 >/dev/null && /usr/sbin/ntpdate -b ${SERVER} 2>&1 >/dev/null ) &" >> /root/GetDate.sh
			chmod +x /root/GetDate.sh
			if [ "$(grep -c "GetDate.sh" /etc/network/interfaces)" = 0 ];then
				echo "Eintrag nicht vorhanden"
				echo "Erstelle eintrag"			
				sed -e '$a\up /root/GetDate.sh' -i /etc/network/interfaces
			else
				echo "Eintrag vorhanden"							
			fi
			sleep 10
		fi

		if [ "$lang" = "Y" -o "$lang" = "y" ]; then

			echo "Language wird Installiert!"
			echo ""
			sleep 2
			apt-get -y --force-yes install $LIB_SPRACH
			clear
			echo ""
			echo ""
			echo ""
			echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo "         !!                                             !!"
			echo "         !!                                             !!"
			echo "         !!               ACHTUNG                       !!"
			echo "         !!                                             !!"
			echo "         !!       BITTE de_DE.UTF-8 Auswählen           !!"
			echo "         !!                                             !!"
			echo "         !!                                             !!"
			echo "         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			sleep 10		
			dpkg-reconfigure locales
			sleep 10
		fi
clear
		
		if [ "$oscamd" = "Y" -o "$oscamd" = "y" ]; then

			echo "Oscam wird Installiert!"
			
			echo "Verzeichniss für Installation eingeben!"
			echo "Beispiel:/home/Test/oscam/"
			echo "Wenn Sie nichts eintragen wird das Standard Verzeichniss gewählt"
			echo -n "Pfad:"
				read oscamdir
				if [ -z "$oscamdir" ];then 
					oscamdir=/usr/local/bin/
					echo "Kein Verzeichniss gewählt!"
				else
					if [ ! "$( echo "$oscamdir" | grep ^/ )" ];then
	                                        oscamdir=/"$oscamdir"
					fi
					if [ ! "$( echo "$oscamdir" | grep /\$ )" ];then
                                                oscamdir="$oscamdir"/
					fi

					mkdir "$oscamdir"				
				fi
				echo "Nehme Verzeichniss:$oscamdir"				
					
			echo "Verzeichniss für Config eingeben!"
			echo "Beispiel:/home/Test/oscam/"
			echo "Wenn Sie nichts eintragen wird das Standard Verzeichniss gewählt"
			echo -n "Pfad:"
				read configdir
				if [ -z "$configdir" ];then 
					configdir=/usr/local/etc/				
					echo "Kein Verzeichniss gewählt"
				else
					if [ ! "$( echo "$configdir" | grep ^/ )" ];then
	                                        configdir=/"$configdir"
					fi
					if [ ! "$( echo "$configdir" | grep /\$ )" ];then
                                                configdir="$configdir"/
					fi

					mkdir "$configdir"
				fi
				echo "Nehme Verzeichniss:$configdir"
			
			echo "Erstelle Init.d eintrag:"
####################################################################################################################				
####################################################################################################################
#/etc/init.d/oscamstart
echo '#!/bin/sh										'> /etc/init.d/oscamstart
echo '											'>> /etc/init.d/oscamstart
echo '# /etc/init.d/oscam								'>> /etc/init.d/oscamstart
echo '											'>> /etc/init.d/oscamstart
echo '### BEGIN INIT INFO								'>> /etc/init.d/oscamstart
echo '# Provides:          oscam							'>> /etc/init.d/oscamstart
echo '# Required-Start:    $network $local_fs $remote_fs				'>> /etc/init.d/oscamstart	
echo '# Required-Stop:     $network $local_fs $remote_fs				'>> /etc/init.d/oscamstart
echo '# Default-Start:     2 3 4 5							'>> /etc/init.d/oscamstart
echo '# Default-Stop:      0 1 6							'>> /etc/init.d/oscamstart
echo '# Short-Description: OSCAM Card Sharing Deamon					'>> /etc/init.d/oscamstart
echo '# Description: Start/Stop/Uptadte for init-V					'>> /etc/init.d/oscamstart
echo '# Author: LarsRosen@streamboard.tv						'>> /etc/init.d/oscamstart
echo '### END INIT INFO									'>> /etc/init.d/oscamstart
echo '#Configuration									'>> /etc/init.d/oscamstart
echo "DAEMON="$oscamdir"oscam								">> /etc/init.d/oscamstart
echo 'OPTIONS="-b"									'>> /etc/init.d/oscamstart
echo "OSCAMDIR="$oscamdir"								">> /etc/init.d/oscamstart
echo "CONFIGDIR="$configdir"								">> /etc/init.d/oscamstart
echo 'BUILDDIR=/root/oscam-svn/								'>> /etc/init.d/oscamstart
echo 'PID="$(pidof oscam)"								'>> /etc/init.d/oscamstart
echo '											'>> /etc/init.d/oscamstart
echo 'PATH=/sbin:/bin:/usr/sbin:/usr/bin						'>> /etc/init.d/oscamstart
echo '											'>> /etc/init.d/oscamstart
echo 'case $1 in									'>> /etc/init.d/oscamstart
echo '    start)									'>> /etc/init.d/oscamstart
echo '		if [ -z "$(pidof "oscam")" ];then					'>> /etc/init.d/oscamstart
echo '	 	 	echo 2 > /proc/cpu/alignment					'>> /etc/init.d/oscamstart
echo '			if [ ! -z "$(date |grep "1970")" ];then				'>> /etc/init.d/oscamstart
echo '	 	 		echo "Warte auf Aktuelles Datum"			'>> /etc/init.d/oscamstart
echo '				sleep 25						'>> /etc/init.d/oscamstart
echo '			fi								'>> /etc/init.d/oscamstart
echo '			chmod 755 "$CONFIGDIR"*						'>> /etc/init.d/oscamstart
echo '			chmod 755 "$DAEMON"						'>> /etc/init.d/oscamstart
echo "       			"$OSCAM_START"						">> /etc/init.d/oscamstart
echo '        else									'>> /etc/init.d/oscamstart
echo '		      echo "Oscam is running"						'>> /etc/init.d/oscamstart
echo '		fi									'>> /etc/init.d/oscamstart
echo '   ;;										'>> /etc/init.d/oscamstart
echo '											'>> /etc/init.d/oscamstart
echo '     stop)									'>> /etc/init.d/oscamstart
echo '	   										'>> /etc/init.d/oscamstart
echo '		echo "$PID wird gestoppt"						'>> /etc/init.d/oscamstart
echo "		"$OSCAMS_STOP"								">> /etc/init.d/oscamstart
echo '	   	sleep 5									'>> /etc/init.d/oscamstart
echo '       	kill $PID 2>/dev/null							'>> /etc/init.d/oscamstart
echo '    ;;										'>> /etc/init.d/oscamstart
echo '											'>> /etc/init.d/oscamstart
echo '  restart)									'>> /etc/init.d/oscamstart
echo '	 		$0 stop								'>> /etc/init.d/oscamstart
echo '			sleep 10							'>> /etc/init.d/oscamstart
echo '			$0 start							'>> /etc/init.d/oscamstart
echo '    ;;										'>> /etc/init.d/oscamstart
echo '											'>> /etc/init.d/oscamstart
echo '   update)									'>> /etc/init.d/oscamstart
echo '			echo "Oscam wird up to date gebracht"				'>> /etc/init.d/oscamstart
echo '			if [ ! -z $2 ];then						'>> /etc/init.d/oscamstart
echo '				BUILD=" -r $2"						'>> /etc/init.d/oscamstart
echo '				rm -r $BUILDDIR						'>> /etc/init.d/oscamstart
echo '			fi								'>> /etc/init.d/oscamstart
echo '			if [ ! -s "$BUILDDIR"Makefile ];then				'>> /etc/init.d/oscamstart
echo '			svn co http://streamboard.tv/svn/oscam/trunk $BUILDDIR $BUILD'>> /etc/init.d/oscamstart	 
echo '			else								'>> /etc/init.d/oscamstart
echo '			cd $BUILDDIR							'>> /etc/init.d/oscamstart
echo '			svn up								'>> /etc/init.d/oscamstart
echo '			cd /								'>> /etc/init.d/oscamstart
echo '			fi								'>> /etc/init.d/oscamstart
echo '			cd $BUILDDIR							'>> /etc/init.d/oscamstart
echo '			make clean							'>> /etc/init.d/oscamstart
echo '			cmake -DWEBIF=1 cmake . ./					'>> /etc/init.d/oscamstart
echo '			make								'>> /etc/init.d/oscamstart
echo '			cd /								'>> /etc/init.d/oscamstart
echo '			echo "Oscam fertig erstellt"					'>> /etc/init.d/oscamstart
echo '			echo -n "Soll Oscam Kopiert werden? Y/N:"			'>> /etc/init.d/oscamstart
echo '			read close							'>> /etc/init.d/oscamstart
echo '			if [ "$close" = "Y" -o "$close" = "y" ];then			'>> /etc/init.d/oscamstart
echo '				echo "Oscam beenden"					'>> /etc/init.d/oscamstart
echo '				/etc/init.d/oscamstart stop				'>> /etc/init.d/oscamstart
echo '				mv $DAEMON "$OSCAMDIR"oscam_old				'>> /etc/init.d/oscamstart
echo '				cp "$BUILDDIR"oscam $OSCAMDIR				'>> /etc/init.d/oscamstart
echo '			fi								'>> /etc/init.d/oscamstart
echo '			echo -n "Soll Oscam gestartet werden? Y/N:"			'>> /etc/init.d/oscamstart
echo '			read oscam							'>> /etc/init.d/oscamstart
echo '				if [ "$oscam" = "y" -o "$oscam" = "Y" ];then		'>> /etc/init.d/oscamstart
echo '					echo "Oscam wird gestartet"			'>> /etc/init.d/oscamstart
echo '					/etc/init.d/oscamstart start			'>> /etc/init.d/oscamstart
echo '				fi							'>> /etc/init.d/oscamstart
echo '   ;;										'>> /etc/init.d/oscamstart
echo '	config)										'>> /etc/init.d/oscamstart
echo '				$BUILDDIR/config.sh					'>> /etc/init.d/oscamstart
echo '	 ;;										'>> /etc/init.d/oscamstart
echo '   *)										'>> /etc/init.d/oscamstart
echo '		echo "Usage: /etc/init.d/oscam {start|stop|restart|update|config}" >&2	'>> /etc/init.d/oscamstart
echo '    										'>> /etc/init.d/oscamstart
echo '    	echo "start Startet Oscam" >&2						'>> /etc/init.d/oscamstart
echo '		echo "stop: Stopt Oscam" >&2						'>> /etc/init.d/oscamstart
echo '    	echo "restart: Startet Oscam neu" >&2					'>> /etc/init.d/oscamstart
echo '		echo "update: updatet Oscam zur aktuelen rev" >&2			'>> /etc/init.d/oscamstart
echo '    	echo "update XXXX:updatet Oscam auf REV XXXX" >&2			'>> /etc/init.d/oscamstart
echo '    	echo "config: Ruft das Config.sh Script auf" >&2			'>> /etc/init.d/oscamstart
echo '    										'>> /etc/init.d/oscamstart
echo '    										'>> /etc/init.d/oscamstart
echo '    										'>> /etc/init.d/oscamstart#
echo '        exit 1									'>> /etc/init.d/oscamstart
echo '    ;;										'>> /etc/init.d/oscamstart
echo 'esac										'>> /etc/init.d/oscamstart
echo 'exit 0										'>> /etc/init.d/oscamstart

#End /etc/init.d/oscamstart						
####################################################################################################################				
####################################################################################################################

				echo "Eintrag erstellt"
				chmod +x /etc/init.d/oscamstart
				echo "Update rc.d"
				sleep 5
				update-rc.d oscamstart start
				sleep 3
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.ac
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.cert
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.guess
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.ird
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.provid
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.server
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.services
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.srvid
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.tiers
		wget -nc -P $configdir http://streamboard.tv/svn/oscam/trunk/Distribution/doc/example/oscam.user
		if [ ! -e "$configdir"/oscam.conf ];then
			echo "Config wird erstellt"

#####################################################################################################################
#####################################################################################################################
#Oscam.Config
echo '# oscam.conf generated automatically by Streamboard OSCAM 0.99.4svn build #2947  
# Read more: http://streamboard.tv/oscam/browser/trunk/Distribution/doc/txt/o

[global]
#logfile                       = /tmp/oscam.log
#pidfile                       = /var/run/oscam.pid
disablelog                    = 0   
disableuserfile               = 0   
usrfileflag                   = 0   
clienttimeout                 = 5000
fallbacktimeout               = 2500
clientmaxidle                 = 120 
cachedelay                    = 300 
bindwait                      = 120 
netprio                       = 0   
clientdyndns                  = 0   
resolvedelay                  = 30  
unlockparental                = 0   
nice                          = -12 
serialreadertimeout           = 1500
maxlogsize                    = 1000
waitforcards                  = 1
preferlocalcards              = 1
saveinithistory               = 0   
readerrestartseconds          = 5   
readerautoloadbalance         = 0   
readerautoloadbalance_save    = 0   

[webif]
httpport                      = 8888
httpuser                      = myusername
httppwd                       = mypassword
httprefresh                   = 30
httpallowed                   = 192.168.0.0-192.168.255.255
httphideidleclients           = 0
httpreadonly                  = 0
'	> "$configdir"/oscam.conf



#End .Config
#####################################################################################################################
#####################################################################################################################
	
				else
					echo "Config existiert schon"
				fi	
					
					if [ "$watch" = "Y" -o "$watch" = "y" ]; then		
echo "#!/bin/sh

while true ; do 
"$oscamdir"oscam -c "$configdir"
kill $(pidof oscam) 
sleep 10 #nur zur Sicherheit falls oscamd länger zum sterben braucht
done" > "$configdir"oscams.sh
					 
					fi
					if [ "$oscam_build" = "Y" -o "$oscam_build" = "y" ]; then
						/etc/init.d/oscamstart update
						sleep 3
						echo "Oscam Installation Abgeschlossen"				
					fi				
		fi
							
			sleep 5

exit
